%% Case 01

Sc1EZOp = InputS3 (:,[4,5,6,7]);
Sc2EZOp = InputS3 (:,[10,11,12,13]);
Sc3EZOp = InputS3 (:,[16,17,18,19]);
Sc4EZOp = InputS3 (:,[22,23,24,25]);
Sc5EZOp = InputS3 (:,[28,29,30,31]);

Sc1EZOp = table2array (Sc1EZOp);
Sc2EZOp = table2array (Sc2EZOp);
Sc3EZOp = table2array (Sc3EZOp);
Sc4EZOp = table2array (Sc4EZOp);
Sc5EZOp = table2array (Sc5EZOp);

Sc1HWD = InputS3 (:,3);
Sc1HWD = table2array (Sc1HWD);
Sc1HWD.Year = 2019;
Sc2HWD = InputS3 (:,9);
Sc2HWD = table2array (Sc2HWD);
Sc2HWD.Year = 2038;
Sc3HWD = InputS3 (:,15);
Sc3HWD = table2array (Sc3HWD);
Sc3HWD.Year = 2047;
Sc4HWD = InputS3 (:,21);
Sc4HWD = table2array (Sc4HWD);
Sc4HWD.Year = 2073;
Sc5HWD = InputS3 (:,27);
Sc5HWD = table2array (Sc5HWD);
Sc5HWD.Year = 2098;

figure (1)

tiledlayout (3,1);

ax1 = nexttile;

plot (Sc1HWD,Sc1EZOp,'LineWidth',3);

title ('Scenario 01\_HW (2019)','FontSize',14);
a = get(gca,'XTickLabel');
set(gca,'XTickLabel',a,'FontSize',10);
set(gca,'XMinorTick','on');
set(gca,'YMinorTick','on')

datetick('x','dd-mmm','keeplimits');
ylabel ('IOpT [^oC]','FontSize',17);

set(gca,'FontSize',17);

set(gca,'XMinorTick','on');
hold on
ff = yline (26,'LineWidth',2);

%legend ({'Office','Bedroom 01','Bedroom 02','Living+kitchen','MaxLim\_Cat II'},'location','westoutside','FontSize',12);
text(1.005,.4,'26^oC','FontSize',17,'Units','normalized')
hold off

 
ax3 = nexttile


plot (Sc3HWD,Sc3EZOp,'LineWidth',3);

title ('Scenario 02\_HW (2047)','FontSize',18)
set(gca,'XMinorTick','on')
e = get(gca,'XTickLabel');
set(gca,'XTickLabel',e,'FontSize',10)
set(gca,'YMinorTick','on')
datetick('x','dd-mmm','keeplimits');
ylabel ('IOpT [^oC]','FontSize',17);
set(gca,'FontSize',17);

hold on
yline (26,'LineWidth',2);

%legend ({'Office','Bedroom 01','Bedroom 02','Living+kitchen','MaxLim\_Cat II'},'location','westoutside','FontSize',12);
text(1.005,.4,'26^oC','FontSize',17,'Units','normalized')
 hold off 

ax4 = nexttile


plot (Sc4HWD,Sc4EZOp,'LineWidth',3);

title ('Scenario 03\_HW (2098)','FontSize',18)
g = get(gca,'XTickLabel');
set(gca,'XTickLabel',g,'FontSize',10)
set(gca,'XMinorTick','on')
set(gca,'YMinorTick','on')
datetick('x','dd-mmm','keeplimits');
dl = datetime('23-June-2073');
dr = datetime('09-July-2073');
xlim([dl dr])
ylabel ('IOpT [^oC]','FontSize',17);
set(gca,'FontSize',17);
hold on
yline (26,'LineWidth',2);

% legend ({'Office','Bedroom 01','Bedroom 02','Living+kitchen','MaxLim\_Cat II'},'location','southoutside','FontSize',12);
text(1.005,.4,'26^oC','FontSize',17,'Units','normalized')
 hold off 


ax1.YLim = [21 36];
linkaxes([ax1,ax3,ax4],'y');


%% Case 02

Sc1CZOp = InputS4 (:,[4,5,6,7]);
Sc2CZOp = InputS4 (:,[10,11,12,13]);
Sc3CZOp = InputS4 (:,[16,17,18,19]);
Sc4CZOp = InputS4 (:,[22,23,24,25]);
Sc5CZOp = InputS4 (:,[28,29,30,31]);

Sc1CZOp = table2array (Sc1CZOp);
Sc2CZOp = table2array (Sc2CZOp);
Sc3CZOp = table2array (Sc3CZOp);
Sc4CZOp = table2array (Sc4CZOp);
Sc5CZOp = table2array (Sc5CZOp);

figure (2)


tiledlayout (3,1)

ax1 = nexttile;
plot (Sc1HWD,Sc1CZOp,'LineWidth',3);

title ('Scenario 01\_HW (2019)','FontSize',14);
a = get(gca,'XTickLabel');
set(gca,'XTickLabel',a,'FontSize',10);
set(gca,'XMinorTick','on');
set(gca,'YMinorTick','on')
set(gca,'FontSize',13);
datetick('x','dd-mmm','keeplimits');
ylabel ('IOpT [^oC]','FontSize',17);
set(gca,'FontSize',17);

hold on
ff = yline (26,'LineWidth',2);

%legend ({'Office','Bedroom 01','Bedroom 02','Living+kitchen','MaxLim\_Cat II'},'location','westoutside','FontSize',12);
text(1.005,.4,'26^oC','FontSize',17,'Units','normalized')
hold off


 
ax3 = nexttile


plot (Sc3HWD,Sc3CZOp,'LineWidth',3);

title ('Scenario 02\_HW (2047)','FontSize',18)
set(gca,'XMinorTick','on')
e = get(gca,'XTickLabel');
set(gca,'XTickLabel',e,'FontSize',10)
set(gca,'YMinorTick','on')
datetick('x','dd-mmm','keeplimits');
ylabel ('IOpT [^oC]','FontSize',17);
set(gca,'FontSize',17);

hold on
yline (26,'LineWidth',2);

%legend ({'Office','Bedroom 01','Bedroom 02','Living+kitchen','MaxLim\_Cat II'},'location','westoutside','FontSize',12);
text(1.005,.4,'26^oC','FontSize',17,'Units','normalized')
 hold off 

ax4 = nexttile


plot (Sc4HWD,Sc4CZOp,'LineWidth',3);

title ('Scenario 03\_HW (2098)','FontSize',18)
g = get(gca,'XTickLabel');
set(gca,'XTickLabel',g,'FontSize',10)
set(gca,'XMinorTick','on')
set(gca,'YMinorTick','on')
datetick('x','dd-mmm','keeplimits');
dl = datetime('23-June-2073');
dr = datetime('09-July-2073');
xlim([dl dr])
ylabel ('IOpT [^oC]','FontSize',17);
set(gca,'FontSize',17);
hold on
yline (26,'LineWidth',2);

%legend ({'Office','Bedroom 01','Bedroom 02','Living+kitchen','MaxLim\_Cat II'},'location','westoutside','FontSize',12);
text(1.005,.4,'26^oC','FontSize',17,'Units','normalized')
 hold off 




ax1.YLim = [21 36];
linkaxes([ax1,ax3,ax4],'y');

%% Case 03

Sc1MZOp = InputS1 (:,[4,5,6,7]);
Sc2MZOp = InputS1 (:,[10,11,12,13]);
Sc3MZOp = InputS1 (:,[16,17,18,19]);
Sc4MZOp = InputS1 (:,[22,23,24,25]);
Sc5MZOp = InputS1 (:,[28,29,30,31]);

Sc1MZOp = table2array (Sc1MZOp);
Sc2MZOp = table2array (Sc2MZOp);
Sc3MZOp = table2array (Sc3MZOp);
Sc4MZOp = table2array (Sc4MZOp);
Sc5MZOp = table2array (Sc5MZOp);


figure (5)

tiledlayout (3,1);

ax1 = nexttile;

plot (Sc1HWD,Sc1MZOp,'LineWidth',3);

title ('Scenario 01\_HW (2019)','FontSize',14);
a = get(gca,'XTickLabel');
set(gca,'XTickLabel',a,'FontSize',10);
set(gca,'XMinorTick','on');
set(gca,'YMinorTick','on')

datetick('x','dd-mmm','keeplimits');
ylabel ('IOpT [^oC]','FontSize',17);

set(gca,'FontSize',17);

set(gca,'XMinorTick','on');
hold on
ff = yline (26,'LineWidth',2);

%legend ({'Office','Bedroom 01','Bedroom 02','Living+kitchen','MaxLim\_Cat II'},'location','westoutside','FontSize',12);
text(1.005,.4,'26^oC','FontSize',17,'Units','normalized')
hold off


 
ax3 = nexttile


plot (Sc3HWD,Sc3MZOp,'LineWidth',3);

title ('Scenario 02\_HW (2047)','FontSize',18)
set(gca,'XMinorTick','on')
e = get(gca,'XTickLabel');
set(gca,'XTickLabel',e,'FontSize',10)
set(gca,'YMinorTick','on')
datetick('x','dd-mmm','keeplimits');
ylabel ('IOpT [^oC]','FontSize',17);
set(gca,'FontSize',17);

hold on
yline (26,'LineWidth',2);

%legend ({'Office','Bedroom 01','Bedroom 02','Living+kitchen','MaxLim\_Cat II'},'location','westoutside','FontSize',12);
text(1.005,.4,'26^oC','FontSize',17,'Units','normalized')
 hold off 

ax4 = nexttile


plot (Sc4HWD,Sc4MZOp,'LineWidth',3);

title ('Scenario 03\_HW (2098)','FontSize',18)
g = get(gca,'XTickLabel');
set(gca,'XTickLabel',g,'FontSize',10)
set(gca,'XMinorTick','on')
set(gca,'YMinorTick','on')
datetick('x','dd-mmm','keeplimits');
dl = datetime('23-June-2073');
dr = datetime('09-July-2073');
xlim([dl dr])
ylabel ('IOpT [^oC]','FontSize',17);
set(gca,'FontSize',17);
hold on
yline (26,'LineWidth',2);

% legend ({'Office','Bedroom 01','Bedroom 02','Living+kitchen','MaxLim\_Cat II'},'location','southoutside','FontSize',12);
text(1.005,.4,'26^oC','FontSize',17,'Units','normalized')
 hold off 




ax1.YLim = [21 36];
linkaxes([ax1,ax3,ax4],'y');


%% Heatwave area chart


% x = Number of days (duration)
% y = maximum daily mean temperature
% sz = intensity



y = InputS5 (:,[2,4,6,8,10]);
x = InputS5 (:,1);

y = table2array (y);
x = table2array (x);

x = transpose(x);

figure (3)
tiledlayout (3,1);

ax3 = nexttile

ff = area(x,y(:,1))
ff.FaceColor = '#FFFF00';


set(gca,'YMinorTick','on')
set(gca,'XMinorTick','on')
ylim ([10 50])


grid(gca,'minor')
grid on
set(gca,'FontSize',14);

ylabel ('Outdoor air temperature [^oC]','FontSize',16);
xlabel ('Duration [h]','FontSize',16);
xlim ([0 240])
title ('Scenario 01\_HW (2019)','FontSize',18)
ax2 = nexttile

cc = area(x,y(:,3))
cc.FaceColor = '#FFCCCC';
 
set(gca,'YMinorTick','on')
set(gca,'XMinorTick','on')
ylim ([10 50])
xlim ([0 240])

grid(gca,'minor')
grid on
set(gca,'FontSize',14);

ylabel ('Outdoor air temperature [^oC]','FontSize',16);
xlabel ('Duration [h]','FontSize',16);
title ('Scenario 02\_HW (2047)','FontSize',18)
ax1 = nexttile

bb = area(x,y(:,4))
bb.FaceColor = '#FF0000';
 set(gca,'YMinorTick','on')
set(gca,'XMinorTick','on')
ylim ([10 50])


grid(gca,'minor')
grid on
set(gca,'FontSize',14);
xlim ([0 240])
ylabel ('Outdoor air temperature [^oC]','FontSize',16);
xlabel ('Duration [h]','FontSize',16);
title ('Scenario 03\_HW (2098)','FontSize',18)
%% IOhD, AWD & CCOR

%AWD

y1 = InputS6 (:,[1,2,3,4,5,6,7,8,9,10]);
y1= table2array (y1);

ySc1 = y1 (:,2);
ySc1 = ySc1(all(~isnan(ySc1),2),:);
ySc1h = ~ySc1 == 0;
p1 = length (ySc1h);
ySc1 = y1 (:,1);
ySc1 = ySc1 - 18;
AWDSc1 = sum (ySc1(ySc1 >= 0)) / p1;

ySc2 = y1 (:,4);
ySc2 = ySc2(all(~isnan(ySc2),2),:);
ySc2h = ~ySc2 == 0;
p2 = length (ySc2h);
ySc2 = y1 (:,3);
ySc2 = ySc2 - 18;
AWDSc2 = sum (ySc2(ySc2 >= 0)) / p2;

ySc3 = y1 (:,6);
ySc3 = ySc3(all(~isnan(ySc3),2),:);
ySc3h = ~ySc3 == 0;
p3 = length (ySc3h);
ySc3 = y1 (:,5);
ySc3 = ySc3 - 18;
AWDSc3 = sum (ySc3(ySc3 >= 0)) / p3;

ySc4 = y1 (:,8);
ySc4 = ySc4(all(~isnan(ySc4),2),:);
ySc4h = ~ySc4 == 0;
p4 = length (ySc4h);
ySc4 = y1 (:,7);
ySc4 = ySc4 - 18;
AWDSc4 = sum (ySc4(ySc4 >= 0)) / p4;

ySc5 = y1 (:,10);
ySc5 = ySc5(all(~isnan(ySc5),2),:);
ySc5h = ~ySc5 == 0;
p5 = length (ySc5h);
ySc5 = y1 (:,9);
ySc5 = ySc5 - 18;
AWDSc5 = sum (ySc5(ySc5 >= 0)) / p5;

%IOhD

% Discomfort 

kSc11 = InputS6 (:,[13,14,15,16]);
kSc11 = table2array (kSc11);
kSc1 = kSc11 (:,1);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1 (:,1) ==0);
kSc1Oc1 =  length (Positive01)
kSc1 = kSc11 (:,2);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc2 =  length (Positive01)
kSc1 = kSc11 (:,3);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc3 =  length (Positive01)
kSc1 = kSc11 (:,4);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc4 =  length (Positive01)

for i = 1:length (kSc11)
    j = 1:4;
    XXSc1 (i,j) = kSc11(i,j) - 26;
end
IODSc1 = sum (XXSc1(XXSc1>=0))/(kSc1Oc1+kSc1Oc2+kSc1Oc3+kSc1Oc4);



kSc11 = InputS6 (:,[18,19,20,21]);
kSc11 = table2array (kSc11);
kSc1 = kSc11 (:,1);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1 (:,1) ==0);
kSc1Oc1 =  length (Positive01)
kSc1 = kSc11 (:,2);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc2 =  length (Positive01)
kSc1 = kSc11 (:,3);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc3 =  length (Positive01)
kSc1 = kSc11 (:,4);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc4 =  length (Positive01)

for i = 1:length (kSc11)
    j = 1:4;
    XXSc1 (i,j) = kSc11(i,j) - 26;
end
IODSc2D = sum (XXSc1(XXSc1>=0))/(kSc1Oc1+kSc1Oc2+kSc1Oc3+kSc1Oc4);


kSc11 = InputS6 (:,[23,24,25,26]);
kSc11 = table2array (kSc11);
kSc1 = kSc11 (:,1);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1 (:,1) ==0);
kSc1Oc1 =  length (Positive01)
kSc1 = kSc11 (:,2);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc2 =  length (Positive01)
kSc1 = kSc11 (:,3);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc3 =  length (Positive01)
kSc1 = kSc11 (:,4);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc4 =  length (Positive01)

for i = 1:length (kSc11)
    j = 1:4;
    XXSc1 (i,j) = kSc11(i,j) - 26;
end
IODSc3D = sum (XXSc1(XXSc1>=0))/(kSc1Oc1+kSc1Oc2+kSc1Oc3+kSc1Oc4);


kSc11 = InputS6 (:,[28,29,30,31]);
kSc11 = table2array (kSc11);
kSc1 = kSc11 (:,1);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1 (:,1) ==0);
kSc1Oc1 =  length (Positive01)
kSc1 = kSc11 (:,2);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc2 =  length (Positive01)
kSc1 = kSc11 (:,3);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc3 =  length (Positive01)
kSc1 = kSc11 (:,4);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc4 =  length (Positive01)

for i = 1:length (kSc11)
    j = 1:4;
    XXSc1 (i,j) = kSc11(i,j) - 26;
end
IODSc4D = sum (XXSc1(XXSc1>=0))/(kSc1Oc1+kSc1Oc2+kSc1Oc3+kSc1Oc4);


kSc11 = InputS6 (:,[33,34,35,36]);
kSc11 = table2array (kSc11);
kSc1 = kSc11 (:,1);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1 (:,1) ==0);
kSc1Oc1 =  length (Positive01)
kSc1 = kSc11 (:,2);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc2 =  length (Positive01)
kSc1 = kSc11 (:,3);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc3 =  length (Positive01)
kSc1 = kSc11 (:,4);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc4 =  length (Positive01)

for i = 1:length (kSc11)
    j = 1:4;
    XXSc1 (i,j) = kSc11(i,j) - 26;
end
IODSc5D = sum (XXSc1(XXSc1>=0))/(kSc1Oc1+kSc1Oc2+kSc1Oc3+kSc1Oc4);

% Energy



kSc11 = InputS6 (:,[39,40,41,42]);
kSc11 = table2array (kSc11);
kSc1 = kSc11 (:,1);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1 (:,1) ==0);
kSc1Oc1 =  length (Positive01)
kSc1 = kSc11 (:,2);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc2 =  length (Positive01)
kSc1 = kSc11 (:,3);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc3 =  length (Positive01)
kSc1 = kSc11 (:,4);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc4 =  length (Positive01)

for i = 1:length (kSc11)
    j = 1:4;
    XXSc1 (i,j) = kSc11(i,j) - 26;
end
IODSc1E = sum (XXSc1(XXSc1>=0))/(kSc1Oc1+kSc1Oc2+kSc1Oc3+kSc1Oc4);


kSc11 = InputS6 (:,[44,45,46,47]);
kSc11 = table2array (kSc11);
kSc1 = kSc11 (:,1);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1 (:,1) ==0);
kSc1Oc1 =  length (Positive01)
kSc1 = kSc11 (:,2);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc2 =  length (Positive01)
kSc1 = kSc11 (:,3);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc3 =  length (Positive01)
kSc1 = kSc11 (:,4);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc4 =  length (Positive01)

for i = 1:length (kSc11)
    j = 1:4;
    XXSc1 (i,j) = kSc11(i,j) - 26;
end
IODSc2E = sum (XXSc1(XXSc1>=0))/(kSc1Oc1+kSc1Oc2+kSc1Oc3+kSc1Oc4);

kSc11 = InputS6 (:,[49,50,51,52]);
kSc11 = table2array (kSc11);
kSc1 = kSc11 (:,1);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1 (:,1) ==0);
kSc1Oc1 =  length (Positive01)
kSc1 = kSc11 (:,2);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc2 =  length (Positive01)
kSc1 = kSc11 (:,3);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc3 =  length (Positive01)
kSc1 = kSc11 (:,4);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc4 =  length (Positive01)

for i = 1:length (kSc11)
    j = 1:4;
    XXSc1 (i,j) = kSc11(i,j) - 26;
end
IODSc3E = sum (XXSc1(XXSc1>=0))/(kSc1Oc1+kSc1Oc2+kSc1Oc3+kSc1Oc4);


kSc11 = InputS6 (:,[54,55,56,57]);
kSc11 = table2array (kSc11);
kSc1 = kSc11 (:,1);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1 (:,1) ==0);
kSc1Oc1 =  length (Positive01)
kSc1 = kSc11 (:,2);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc2 =  length (Positive01)
kSc1 = kSc11 (:,3);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc3 =  length (Positive01)
kSc1 = kSc11 (:,4);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc4 =  length (Positive01)

for i = 1:length (kSc11)
    j = 1:4;
    XXSc1 (i,j) = kSc11(i,j) - 26;
end
IODSc4E = sum (XXSc1(XXSc1>=0))/(kSc1Oc1+kSc1Oc2+kSc1Oc3+kSc1Oc4);


kSc11 = InputS6 (:,[59,60,61,62]);
kSc11 = table2array (kSc11);
kSc1 = kSc11 (:,1);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1 (:,1) ==0);
kSc1Oc1 =  length (Positive01)
kSc1 = kSc11 (:,2);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc2 =  length (Positive01)
kSc1 = kSc11 (:,3);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc3 =  length (Positive01)
kSc1 = kSc11 (:,4);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc4 =  length (Positive01)

for i = 1:length (kSc11)
    j = 1:4;
    XXSc1 (i,j) = kSc11(i,j) - 26;
end
IODSc5E = sum (XXSc1(XXSc1>=0))/(kSc1Oc1+kSc1Oc2+kSc1Oc3+kSc1Oc4);

% Mid-point 

kSc11 = InputS6 (:,[65,66,67,68]);
kSc11 = table2array (kSc11);
kSc1 = kSc11 (:,1);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1 (:,1) ==0);
kSc1Oc1 =  length (Positive01)
kSc1 = kSc11 (:,2);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc2 =  length (Positive01)
kSc1 = kSc11 (:,3);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc3 =  length (Positive01)
kSc1 = kSc11 (:,4);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc4 =  length (Positive01)

for i = 1:length (kSc11)
    j = 1:4;
    XXSc1 (i,j) = kSc11(i,j) - 26;
end
IODSc1M = sum (XXSc1(XXSc1>=0))/(kSc1Oc1+kSc1Oc2+kSc1Oc3+kSc1Oc4);



kSc11 = InputS6 (:,[70,71,72,73]);
kSc11 = table2array (kSc11);
kSc1 = kSc11 (:,1);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1 (:,1) ==0);
kSc1Oc1 =  length (Positive01)
kSc1 = kSc11 (:,2);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc2 =  length (Positive01)
kSc1 = kSc11 (:,3);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc3 =  length (Positive01)
kSc1 = kSc11 (:,4);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc4 =  length (Positive01)

for i = 1:length (kSc11)
    j = 1:4;
    XXSc1 (i,j) = kSc11(i,j) - 26;
end
IODSc2M = sum (XXSc1(XXSc1>=0))/(kSc1Oc1+kSc1Oc2+kSc1Oc3+kSc1Oc4);


kSc11 = InputS6 (:,[75,76,77,78]);
kSc11 = table2array (kSc11);
kSc1 = kSc11 (:,1);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1 (:,1) ==0);
kSc1Oc1 =  length (Positive01)
kSc1 = kSc11 (:,2);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc2 =  length (Positive01)
kSc1 = kSc11 (:,3);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc3 =  length (Positive01)
kSc1 = kSc11 (:,4);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc4 =  length (Positive01)

for i = 1:length (kSc11)
    j = 1:4;
    XXSc1 (i,j) = kSc11(i,j) - 26;
end
IODSc3M = sum (XXSc1(XXSc1>=0))/(kSc1Oc1+kSc1Oc2+kSc1Oc3+kSc1Oc4);


kSc11 = InputS6 (:,[80,81,82,83]);
kSc11 = table2array (kSc11);
kSc1 = kSc11 (:,1);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1 (:,1) ==0);
kSc1Oc1 =  length (Positive01)
kSc1 = kSc11 (:,2);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc2 =  length (Positive01)
kSc1 = kSc11 (:,3);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc3 =  length (Positive01)
kSc1 = kSc11 (:,4);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc4 =  length (Positive01)

for i = 1:length (kSc11)
    j = 1:4;
    XXSc1 (i,j) = kSc11(i,j) - 26;
end
IODSc4M = sum (XXSc1(XXSc1>=0))/(kSc1Oc1+kSc1Oc2+kSc1Oc3+kSc1Oc4);


kSc11 = InputS6 (:,[85,86,87,88]);
kSc11 = table2array (kSc11);
kSc1 = kSc11 (:,1);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1 (:,1) ==0);
kSc1Oc1 =  length (Positive01)
kSc1 = kSc11 (:,2);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc2 =  length (Positive01)
kSc1 = kSc11 (:,3);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc3 =  length (Positive01)
kSc1 = kSc11 (:,4);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
kSc1 = kSc1(all(~isnan(kSc1),2),:);
Positive01 =  find (~kSc1  ==0);
kSc1Oc4 =  length (Positive01)

for i = 1:length (kSc11)
    j = 1:4;
    XXSc1 (i,j) = kSc11(i,j) - 26;
end
IODSc5M = sum (XXSc1(XXSc1>=0))/(kSc1Oc1+kSc1Oc2+kSc1Oc3+kSc1Oc4);


figure (4)

EE = [IODSc1,IODSc3D,IODSc4D]
DD = [AWDSc1,AWDSc3,AWDSc4]
mdl = fitlm(DD,EE)
RsquareD = mdl.Rsquared.Ordinary
sz=100
scatter (DD,EE,sz,'d','MarkerEdgeColor',[0.9290 0.6940 0.1250],'LineWidth',2);
xt=({AWDSc1;AWDSc3;AWDSc4});
xt=({['Scenario 01\_HW (2019) = ',num2str(AWDSc1)]  ; ['Scenario 03\_HW  = ',num2str(AWDSc3)] ; ['Scenario 05 = ',num2str(AWDSc4)]}) ; 
set(gca,'xtick',DD,'FontSize',12); 
set(gca,'xticklabel',xt);
set(gca,'XTickLabelRotation',0);
hold on

B = [ones(length(DD),1) DD(:)]\EE(:);   
yf = [ones(length(DD),1) DD(:)]*B; 
hCC = plot(DD, yf, 'color',[0.9290 0.6940 0.1250],'LineWidth',3);
BCVFCC = B(2)
interceptCC = B(1)

hold on



EE = [IODSc1E,IODSc3E,IODSc4E]
DD = [AWDSc1,AWDSc3,AWDSc4]
mdl = fitlm(DD,EE)
RsquareE = mdl.Rsquared.Ordinary
scatter (DD,EE,sz,'r','MarkerEdgeColor',[0.6350 0.0780 0.1840],'LineWidth',2);



B = [ones(length(DD),1) DD(:)]\EE(:);   
yf = [ones(length(DD),1) DD(:)]*B; 
hVAV = plot(DD, yf,'-r','color',[0.6350 0.0780 0.1840],'LineWidth',3);
BCVFVAV = B(2)
interceptVAV = B(1)


hold on



EE = [IODSc1M,IODSc3M,IODSc4M]
DD = [AWDSc1,AWDSc3,AWDSc4]
mdl = fitlm(DD,EE)
RsquareM = mdl.Rsquared.Ordinary
scatter (DD,EE,sz,'r','MarkerEdgeColor',[0 0.4470 0.7410],'LineWidth',2);



B = [ones(length(DD),1) DD(:)]\EE(:);   
yf = [ones(length(DD),1) DD(:)]*B; 
hM = plot(DD, yf,'-r','color',[0 0.4470 0.7410],'LineWidth',3);
BCVFM = B(2)
interceptM = B(1)

legend([hCC hVAV hM],{['  ','R^2=',num2str(round(RsquareD,3)),'  ','CCOR=',num2str(round(1/BCVFCC,2)),' \rightarrow Min. IDD (OS01)'],['  ','R^2=',num2str(round(RsquareE,3)),'  ','CCOR=',num2str(round(1/BCVFVAV,2)),' \rightarrow Min. Final HVAC Energy Use (OS02)'],['  ','R^2=',num2str(round(RsquareM,3)),'  ','CCOR=',num2str(round(1/BCVFM,2)),' \rightarrow Compromise Solution (OS03)']},'Location', 'NorthWest','FontSize',12);
xticks([AWDSc1 AWDSc3 AWDSc4 ])
xticklabels({['Scenario 01\_HW (2019) = ',num2str(round(AWDSc1,3))],['Scenario 02\_HW (2047) = ',num2str(round(AWDSc3,3))],['Scenario 03\_HW (2098) = ',num2str(round(AWDSc4,3))]});
xlim([AWDSc1-0.5 AWDSc4+0.5]);
ylim([0 inf]);
ylabel ('IOhD [\circC]','FontSize',14);
xlabel ('AWD [\circC]','FontSize',14)



hold off
